// __multiversion__
// This signals the loading code to prepend either #version 100 or #version 300 es as apropriate.

/*
|==========||==========|
GS Shader 2.1

By Goldshadow12
|==========||==========|
*/

#include "vertexVersionCentroid.h"
#if __VERSION__ >= 300
	#ifndef BYPASS_PIXEL_SHADER
		_centroid out vec2 uv0;
		_centroid out vec2 uv1;
	#endif
#else
	#ifndef BYPASS_PIXEL_SHADER
		out vec2 uv0;
		out vec2 uv1;
	#endif
#endif

#ifndef BYPASS_PIXEL_SHADER
	out vec4 color;
#endif

#ifdef UNWATER
	out vec4 fogColor;
#endif

#include "uniformWorldConstants.h"
#include "uniformPerFrameConstants.h"
#include "uniformShaderConstants.h"
#include "uniformRenderChunkConstants.h"

out highp vec3 position;
out highp vec3 wPos;
out float new_fog;
out vec3 screen_pos;

out highp vec3 look_vector;

out float vignette;

attribute POS4 POSITION;
attribute vec4 COLOR;
attribute vec2 TEXCOORD_0;
attribute vec2 TEXCOORD_1;

void main() {
    
    POS4 worldPos;
    
    #ifdef AS_ENTITY_RENDERER
		POS4 pos = WORLDVIEWPROJ * POSITION;
		worldPos = pos;
    #else
        worldPos.xyz = (POSITION.xyz * CHUNK_ORIGIN_AND_SCALE.w) + CHUNK_ORIGIN_AND_SCALE.xyz;
        worldPos.w = 1.0;

        POS4 pos = WORLDVIEW * worldPos;
        pos = PROJ * pos;
    #endif

    position = POSITION.xyz;
    wPos = worldPos.xyz;
    screen_pos.xy = pos.xy / (pos.z + 1.0);
    screen_pos.z = min(1.,pos.z);

    gl_Position = pos;

    #ifndef BYPASS_PIXEL_SHADER
        uv0 = TEXCOORD_0;
        uv1 = TEXCOORD_1;
    	color = COLOR;
    #endif
    
    vignette = 1. - max(.0,max(.0,length(screen_pos.xy))-.4);

    
    

    const float zp = .5;

    float addfog = length(-worldPos.xz*zp);

    #ifdef UNWATER
        new_fog = addfog / FAR_CHUNKS_DISTANCE*(1.1-uv1.y)*zp;
    #else
        new_fog = mix(addfog / FAR_CHUNKS_DISTANCE*zp,addfog /FAR_CHUNKS_DISTANCE*.3, 1.-uv1.y);
    #endif

    vec3 relPos = -worldPos.xyz;
    float cameraDepth = length(relPos);

    #ifdef UNWATER
    	float len = cameraDepth / RENDER_DISTANCE;
    	#ifdef ALLOW_FADE
    		len += RENDER_CHUNK_FOG_ALPHA;
    	#endif
	
        fogColor.rgb = FOG_COLOR.rgb;
    	fogColor.a = clamp((len - FOG_CONTROL.x) / (FOG_CONTROL.y - FOG_CONTROL.x), 0.0, 1.0);
    #endif


    POS3 cam_fix = worldPos.xyz + VIEW_POS;

    highp vec3 fragment_pos = cam_fix;
    fragment_pos.y += 0.0015;
    look_vector = fragment_pos - VIEW_POS;

}
